/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.utils;

public class Preconditions
{
	private Preconditions() {}


	public static void checkArgument( boolean expression, String errorMessage )
	{
		if( !expression ) {
			throw new IllegalArgumentException( errorMessage );
		}
	}


	public static <T> T checkNotNull( T reference, String errorMessage )
	{
		if( reference == null ) {
			throw new NullPointerException( errorMessage );
		}
		return reference;
	}


	public static void checkContainsKey( Multimap<String,?> map, String key, String errorMessage )
	{
		if( !map.containsKey( key ) ) {
			throw new IllegalArgumentException( errorMessage );
		}
	}
}
