/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.utils;

import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Wrapper class used to provide helpful methods around the generic {@link Number} class
 */
public class NumberConverter
{
	private final Double number;

	public NumberConverter( Number number ) {
		this.number = number.doubleValue();
	}


	public static Map<String,NumberConverter> toNumberConverter( Map<String,Number> map )
	{
		if( MapUtils.isEmpty( map ) ) {
			return MapUtils.newHashMap();
		}

		return map.entrySet().stream()
			.collect( Collectors.toMap(
				Map.Entry::getKey,
				entry -> new NumberConverter( entry.getValue() ) ) );
	}


	public boolean hasDecimals() {
		return number % 1 != 0;
	}

	public Long longValue() {
		return number.longValue();
	}

	public Double doubleValue() {
		return number;
	}

	public BigDecimal bigDecimalValue() {
		return BigDecimal.valueOf( number );
	}
}
