/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.utils;

import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;

import io.mambo.sdk.exception.MamboException;

public class HttpUtils
{
	private HttpUtils() {}


	public static Proxy buildProxy( String proxyUri )
	{
		try {
			URL proxyUrl = new URL( proxyUri );
			return new Proxy(
			    Proxy.Type.HTTP,
			    new InetSocketAddress( proxyUrl.getHost(), proxyUrl.getPort() )
			);
		}
		catch( MalformedURLException exception ) {
			throw new MamboException( "Move this into the client configuration", exception );
		}
	}
}
