/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.webhook.param;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;

public class WebhookGetListParams implements ServiceParams
{
	private Multimap<String, String> params = new Multimap<>();


	private WebhookGetListParams( Builder builder ) {
		this.params = builder.params();
	}


	public static Builder builder()
	{
		return new Builder();
	}


	@Override
	public Multimap<String, String> asMap()
	{
		return params;
	}


	public static class Builder extends AbstractServiceParamsBuilder<Builder>
	{
		/**
		 * Specifies the number of results to retrieve (1-100)
		 */
		public Builder pageSize( int pageSize )
		{
			params.put( "pageSize", String.valueOf( pageSize ) );
			return this;
		}


		/**
		 * Specifies the cursor after which to retrieve records
		 */
		public Builder pageAfter( String pageAfter )
		{
			params.put( "pageAfter", pageAfter );
			return this;
		}


		/**
		 * Specifies the cursor before which to retrieve records
		 */
		public Builder pageBefore( String pageBefore )
		{
			params.put( "pageBefore", pageBefore );
			return this;
		}


		public WebhookGetListParams build()
		{
			return new WebhookGetListParams( this );
		}


		private Multimap<String, String> params()
		{
			return params;
		}
	}
}
