/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.webhook.model;

import io.mambo.sdk.service.common.model.interfaces.AggregateDto;
import io.mambo.sdk.service.common.model.interfaces.HasId;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a webhook.
 */
@ToString( callSuper = true )
@EqualsAndHashCode( callSuper = true )
public class WebhookDto extends AbstractWebhook implements AggregateDto, HasId
{
	private String id;
	private String createdOn;
	private String updatedOn;
	private DeliverySummaryDto lastDelivery;


	/**
	 * @see AggregateDto#getId()
	 */
	@Override
	public String getId() { return id; }
	public void setId( String id ) { this.id = id; }


	/**
	 * The time and date on which the webhook was created.
	 * This will be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ
	 * @return
	 */
	public String getCreatedOn() { return  createdOn; }
	public void setCreatedOn( String createdOn ) { this.createdOn = createdOn; }


	/**
	 * The time and date on which the webhook was last updated.
	 * This will be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ
	 * @return
	 */
	public String getUpdatedOn() { return  updatedOn; }
	public void setUpdatedOn( String updatedOn ) { this.updatedOn = updatedOn; }


	/**
	 * The summary of the last delivery.
	 * @return
	 */
	public DeliverySummaryDto getLastDelivery() { return  lastDelivery; }
	public void setLastDelivery( DeliverySummaryDto lastDelivery ) { this.lastDelivery = lastDelivery; }
}
