/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.webhook.model;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a webhook's last delivery
 */
@ToString
@EqualsAndHashCode
public class DeliverySummaryDto
{
	private String status;
	private String httpStatusReason;
	private String httpClientError;
	private String completedOn;
	private int httpStatusCode;


	/**
	 * The status of the last delivery made.
	 * @return
	 */
	public String getStatus() { return status; }
	public void setStatus( String status ) { this.status = status; }


	/**
	 * The HTTP status code associated to the last delivery.
	 * @return
	 */
	public int getHttpStatusCode() { return httpStatusCode; }
	public void setHttpStatusCode( int httpStatusCode ) { this.httpStatusCode = httpStatusCode; }


	/**
	 * The HTTP status reason associated to the delivery.
	 * @return
	 */
	public String getHttpStatusReason() { return httpStatusReason; }
	public void setHttpStatusReason( String httpStatusReason ) { this.httpStatusReason = httpStatusReason; }


	/**
	 * The HTTP client error associated to the delivery, if any.
	 * @return
	 */
	public String getHttpClientError() { return httpClientError; }
	public void setHttpClientError( String httpClientError ) { this.httpClientError = httpClientError; }


	/**
	 * The time and date of the last delivery made.
	 * This will be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ
	 * For example: 2013-01-20T20:43:24.094Z
	 * @return
	 */
	public String getCompletedOn() { return completedOn; }
	public void setCompletedOn( String completedOn ) { this.completedOn = completedOn; }
}
