/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.webhook.data;

import java.util.List;

import io.mambo.sdk.service.common.data.RequestData;
import io.mambo.sdk.service.webhook.model.AbstractWebhook;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This object captures the data required by the Webhook API in
 * order to create and update webhooks.
 */
@ToString( callSuper = true )
@EqualsAndHashCode( callSuper = true )
public class WebhookRequestData extends AbstractWebhook implements RequestData
{

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}