/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.user.param;

import io.mambo.sdk.service.common.param.OrderBy;

public enum UserOrderBy implements OrderBy
{
	UUID( "uuid" ),
	EMAIL( "email" ),
	CREATED_ON( "createdOn" ),
	FIRST_NAME( "firstName" ),
	LAST_NAME( "lastName" ),
	REWARDS( "rewards" ),
	LEVELS( "levels" ),
	MISSIONS( "missions" ),
	ACHIEVEMENTS( "achievements" ),
	GIFTS("gifts" ),
	COUPONS( "coupons" ),
	ACTIVITIES( "activities" ),
	IS_MEMBER( "isMember" ),
	LAST_SEEN_ON("lastSeenOn" ),
	MEMBER_SINCE( "memberSince" );

	private String value;

	private UserOrderBy( String value ) {
		this.value = value;
	}


	@Override
	public String value()
	{
		return value;
	}
}