/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.user.model;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a user's stats.
 */
@ToString
@EqualsAndHashCode
public class UserStatsDto
{
	private Long activities;
	private Long coupons;
	private Long rewards;
	private Long levels;
	private Long achievements;
	private Long missions;
	private Long gifts;
	private Long kpis;

	/**
	 * The total number of activities performed by this user
	 * @return
	 */
	public Long getActivities() { return activities; }
	public void setActivities( Long activities ) { this.activities = activities; }

	/**
	 * The total number of coupons earned by this user
	 * @return
	 */
	public Long getCoupons() { return coupons; }
	public void setCoupons( Long coupons ) { this.coupons = coupons; }

	/**
	 * The total number of rewards unlocked by this user
	 * @return
	 */
	public Long getRewards() { return rewards; }
	public void setRewards( Long rewards ) { this.rewards = rewards; }

	/**
	 * The total number of levels unlocked by this user
	 * @return
	 */
	public Long getLevels() { return levels; }
	public void setLevels( Long levels ) { this.levels = levels; }

	/**
	 * The total number of achievements unlocked by this user
	 * @return
	 */
	public Long getAchievements() { return achievements; }
	public void setAchievements( Long achievements ) { this.achievements = achievements; }

	/**
	 * The total number of missions unlocked by this user
	 * @return
	 */
	public Long getMissions() { return missions; }
	public void setMissions( Long missions ) { this.missions = missions; }

	/**
	 * The total number of gifts unlocked by this user
	 * @return
	 */
	public Long getGifts() { return gifts; }
	public void setGifts( Long gifts ) { this.gifts = gifts; }

	/**
	 * The total number of KPI targets met by this user
	 * @return
	 */
	public Long getKpis() { return kpis; }
	public void setKpis( Long kpis ) { this.kpis = kpis; }
}
