/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.user.model;

import java.util.List;

import io.mambo.sdk.service.reward.model.RewardDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This objects is returned by the UsersService getAll[Reward]() methods.
 * The object will contain the list of rewards awarded to the user as well
 * as the full list of available rewards.
 */
@ToString
@EqualsAndHashCode
public class UserRewardsDto
{
	private List<UserAwardedRewardDto> completed;
	private List<RewardDto> available;


	/**
	 * The list of rewards which have been awarded to the user.
	 * @return
	 */
	public List<UserAwardedRewardDto> getCompleted() { return completed; }
	public void setCompleted( List<UserAwardedRewardDto> completed ) { this.completed = completed; }

	/**
	 * The list of rewards available on the system.
	 * @return
	 */
	public List<RewardDto> getAvailable() { return available; }
	public void setAvailable( List<RewardDto> available ) { this.available = available; }
}
