/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.user.model;

import com.fasterxml.jackson.annotation.JsonIgnore;

import io.mambo.sdk.service.point.model.PointDto;
import io.mambo.sdk.utils.NumberConverter;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a user's points.
 * @deprecated
 */
@Deprecated
@ToString
@EqualsAndHashCode
public class UserPointsDto
{
	private String pointId;
	private Number grandTotal;
	private Number spent;
	private Number expired;
	private Number balance;
	private PointDto point;


	/**
	 * The ID that uniquely identifies this Point
	 * @return
	 */
	public String getPointId() { return pointId; }
	public void setPointId( String pointId ) { this.pointId = pointId; }


	/**
	 * The grandTotal of points the user has won by performing behaviours.
	 * This number also includes expired points.
	 * @return
	 */
	public Number getGrandTotal() { return grandTotal; }
	public void setGrandTotal( Number grandTotal ) { this.grandTotal = grandTotal; }

	@JsonIgnore
	public NumberConverter getGrandTotalHelper() { return new NumberConverter( grandTotal ); }


	/**
	 * The total number of points this user has spent so far.
	 * @return
	 */
	public Number getSpent() { return spent; }
	public void setSpent( Number spent ) { this.spent = spent; }

	@JsonIgnore
	public NumberConverter getSpentHelper() { return new NumberConverter( spent ); }


	/**
	 * The total number of points this user has that have already expired.
	 * @return
	 */
	public Number getExpired() { return expired; }
	public void setExpired( Number expired) { this.expired = expired; }

	@JsonIgnore
	public NumberConverter getExpiredHelper() { return new NumberConverter( expired ); }


	/**
	 * The total number of points the user has available to spend.
	 * @return
	 */
	public Number getBalance() { return balance; }
	public void setBalance( Number balance ) { this.balance = balance; }

	@JsonIgnore
	public NumberConverter getBalanceHelper() { return new NumberConverter( balance ); }


	/**
	 * The model representing the underlying point.
	 * @return
	 */
	public PointDto getPoint() { return point; }
	public void setPoint( PointDto point ) { this.point = point; }
}
