/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.user.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a user's details.
 */
@ToString
@EqualsAndHashCode
public class UserDetailsDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private String email;
	private String displayName;
	private String firstName;
	private String lastName;
	private String birthday;
	private String gender;


	/**
	 * The user's email address.
	 * @return
	 */
	public String getEmail() { return email; }
	public void setEmail( String email ) {
		initializedFields.add( "email" );
		this.email = email;
	}

	/**
	 * The name to be displayed when a user's information is being displayed.
	 * @return
	 */
	public String getDisplayName() { return displayName; }
	public void setDisplayName( String displayName ) {
		initializedFields.add( "displayName" );
		this.displayName = displayName;
	}

	/**
	 * The user's first name.
	 * @return
	 */
	public String getFirstName() { return firstName; }
	public void setFirstName( String firstName ) {
		initializedFields.add( "firstName" );
		this.firstName = firstName;
	}

	/**
	 * The user's last name.
	 * @return
	 */
	public String getLastName() { return lastName; }
	public void setLastName( String lastName ) {
		initializedFields.add( "lastName" );
		this.lastName = lastName;
	}

	/**
	 * The user's birthday.
	 * This is expected as a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ
	 * For example: 2013-01-20T20:43:24.094Z
	 * @return
	 */
	public String getBirthday() { return birthday; }
	public void setBirthday( String birthday ) {
		initializedFields.add( "birthday" );
		this.birthday = birthday;
	}

	/**
	 * The user's gender. Valid values include: M, F or U.
	 * M = Male, F = Female, U = Unknown.
	 * @return
	 */
	public String getGender() { return gender; }
	public void setGender( String gender ) {
		initializedFields.add( "gender" );
		this.gender = gender;
	}

	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
