/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.user.model;

import java.util.List;

import io.mambo.sdk.service.common.model.SourceActivityDto;
import io.mambo.sdk.service.common.model.awarded.AwardedRewardDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Provides a wrapper around a Reward that has been unlocked
 * and assigned to a User.
 */
@ToString
@EqualsAndHashCode
public class UserAwardedRewardDto
{
	private String id;
	private String expiryOn;
	private Boolean isExpired;
	private Boolean hasExpiration;
	private Long awardedCounter;
	private List<String> awardedOn;
	private AwardedRewardDto awarded;
	private List<GifterDto> gifters;
	private List<SourceActivityDto> sources;

	/**
	 * This ID uniquely identifies this object
	 */
	public String getId() { return id; }
	public void setId( String id ) { this.id = id; }

	/**
	 * The awarded counter represents the number of times this
	 * specific reward was awarded to the user.
	 * @return
	 */
	public Long getAwardedCounter() { return awardedCounter; }
	public void setAwardedCounter( Long awardedCounter ) { this.awardedCounter = awardedCounter; }

	/**
	 * The list of dates on which this reward was awarded to the
	 * user. This will contain multiple dates for rewards which
	 * have been unlocked multiple times.
	 * This will be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ<br>
	 * For example: 2013-01-20T20:43:24.094Z
	 * @return
	 */
	public List<String> getAwardedOn() { return awardedOn; }
	public void setAwardedOn( List<String> awardedOn ) { this.awardedOn = awardedOn; }

	/**
	 * Get the {@link AwardedRewardDto} representing the reward unlocked by the user.
	 * @see AwardedRewardDto
	 * @return
	 */
	public AwardedRewardDto getAwarded() { return awarded; }
	public void setAwarded( AwardedRewardDto awarded ) { this.awarded = awarded; }

	/**
	 * The date on which the reward is going to expire or has expired on.
	 * This will be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ<br>
	 * For example: 2013-01-20T20:43:24.094Z
	 * @return
	 */
	public String getExpiryOn() { return expiryOn; }
	public void setExpiryOn( String expiryOn ) { this.expiryOn = expiryOn; }

	/**
	 * This indicates whether the reward is expired.
	 */
	public Boolean getIsExpired() { return isExpired; }
	public void setIsExpired( Boolean isExpired ) { this.isExpired = isExpired; }

	/**
	 * This indicates whether the reward has an expiration date.
	 */
	public Boolean getHasExpiration() { return hasExpiration; }
	public void setHasExpiration( Boolean hasExpiration ) { this.hasExpiration = hasExpiration; }

	/**
	 * If the {@link UserAwardedRewardDto} represents a gift then this property
	 * will contain a list of all the givers with their reasons associated
	 * @return
	 */
	public List<GifterDto> getGifters() { return gifters; }
	public void setGifters( List<GifterDto> gifters ) { this.gifters = gifters; }

	/**
	 * If the {@link UserAwardedRewardDto} was triggered by an activity then
	 * this will contain the list of activities that triggered this reward
	 * @return
	 */
	public List<SourceActivityDto> getSources() { return sources; }
	public void setSources( List<SourceActivityDto> sources ) { this.sources = sources; }
}
