/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.user.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.UserSummaryDto;
import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a user's awarded
 * gift reward's gifter
 */
@ToString
@EqualsAndHashCode
public class GifterDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private UserSummaryDto sourceUser;
	private String reason;


	/**
	 * If the {@link UserAwardedRewardDto} is a gift then this will contain the
	 * user who gave the gift. Useful to show this to the target user when
	 * displaying a gift reward
	 * @return
	 */
	public UserSummaryDto getSourceUser() { return sourceUser; }
	public void setSourceUser( UserSummaryDto sourceUser ) {
		initializedFields.add( "sourceUser" );
		this.sourceUser = sourceUser;
	}

	/**
	 * If the {@link UserAwardedRewardDto} is a gift then this will contain the
	 * reason the user who gave the gift sent to the target user
	 * @return
	 */
	public String getReason() { return reason; }
	public void setReason( String reason ) {
		initializedFields.add( "reason" );
		this.reason = reason;
	}

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
