/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.site.model.security;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to the security of the
 * Users JavaScript API.
 */
@ToString
@EqualsAndHashCode
public class UsersJavaScriptSecurityDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private Boolean canCreateUser;
	private Boolean canUpdateUser;


	/**
	 * Whether user's can be created via the JavaScript API
	 * @return
	 */
	public Boolean getCanCreateUser() { return canCreateUser; }
	public void setCanCreateUser( Boolean canCreateUser ) {
		initializedFields.add( "canCreateUser" );
		this.canCreateUser = canCreateUser;
	}

	/**
	 * Whether user's can be updated via the JavaScript API
	 * @return
	 */
	public Boolean getCanUpdateUser() { return canUpdateUser; }
	public void setCanUpdateUser( Boolean canUpdateUser ) {
		initializedFields.add( "canUpdateUser" );
		this.canUpdateUser = canUpdateUser;
	}

	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
