/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.site.model.security;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a site's security settings.
 */
@ToString
@EqualsAndHashCode
public class SecurityDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private ActivitiesJavaScriptSecurityDto jsActivities;
	private UsersJavaScriptSecurityDto jsUsers;


	/**
	 * The Activity JavaScript Security object is used to define which of the activities
	 * can be created through the JavaScript API.
	 * @return
	 */
	public ActivitiesJavaScriptSecurityDto getJsActivities() { return jsActivities; }
	public void setJsActivities( ActivitiesJavaScriptSecurityDto jsActivities ) {
		initializedFields.add( "jsActivities" );
		this.jsActivities = jsActivities;
	}

	/**
	 * The User JavaScript Security object is used to define which of the User
	 * CRUD APIs can be called through the JavaScript API.
	 * @return
	 */
	public UsersJavaScriptSecurityDto getJsUsers() { return jsUsers; }
	public void setJsUsers( UsersJavaScriptSecurityDto jsUsers ) {
		initializedFields.add( "jsUsers" );
		this.jsUsers = jsUsers;
	}

	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
