/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.site.model.security;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to the security of the
 * activities JavaScript API.
 */
@ToString
@EqualsAndHashCode
public class ActivitiesJavaScriptSecurityDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private Boolean canCreateBehaviour;
	private Boolean canRedeemCoupon;
	private Boolean canRefundCoupon;
	private Boolean canSetPoints;
	private Boolean canIncrementPoints;
	private Boolean canRedeemPoints;
	private Boolean canRefundPoints;
	private Boolean canStartBounty;
	private Boolean canAwardBounty;
	private Boolean canCancelBounty;
	private Boolean canCreateGift;


	/**
	 * Whether behaviour activities can be created via the JavaScript API
	 * @return
	 */
	public Boolean getCanCreateBehaviour() { return canCreateBehaviour; }
	public void setCanCreateBehaviour( Boolean canCreateBehaviour ) {
		initializedFields.add( "canCreateBehaviour" );
		this.canCreateBehaviour = canCreateBehaviour;
	}

	/**
	 * Whether coupon redeem activities can be created via the JavaScript API
	 *
	 * @return
	 */
	public Boolean getCanRedeemCoupon() { return canRedeemCoupon; }
	public void setCanRedeemCoupon( Boolean canRedeemCoupon ) {
		initializedFields.add( "canRedeemCoupon" );
		this.canRedeemCoupon = canRedeemCoupon;
	}

	/**
	 * Whether coupon refund activities can be created via the JavaScript API
	 * @return
	 */
	public Boolean getCanRefundCoupon() { return canRefundCoupon; }
	public void setCanRefundCoupon( Boolean canRefundCoupon ) {
		initializedFields.add( "canRefundCoupon" );
		this.canRefundCoupon = canRefundCoupon;
	}

	/**
	 * Whether point set activities can be created via the JavaScript API
	 * @return
	 */
	public Boolean getCanSetPoints() { return canSetPoints; }
	public void setCanSetPoints( Boolean canSetPoints ) {
		initializedFields.add( "canSetPoints" );
		this.canSetPoints = canSetPoints;
	}

	/**
	 * Whether point increment activities can be created via the JavaScript API
	 * @return
	 */
	public Boolean getCanIncrementPoints() { return canIncrementPoints; }
	public void setCanIncrementPoints( Boolean canIncrementPoints ) {
		initializedFields.add( "canIncrementPoints" );
		this.canIncrementPoints = canIncrementPoints;
	}

	/**
	 * Whether point redeem can be created via the JavaScript API
	 * @return
	 */
	public Boolean getCanRedeemPoints() { return canRedeemPoints; }
	public void setCanRedeemPoints( Boolean canRedeemPoints ) {
		initializedFields.add( "canRedeemPoints" );
		this.canRedeemPoints = canRedeemPoints;
	}

	/**
	 * Whether point refund can be created via the JavaScript API
	 * @return
	 */
	public Boolean getCanRefundPoints() { return canRefundPoints; }
	public void setCanRefundPoints( Boolean canRefundPoints ) {
		initializedFields.add( "canRefundPoints" );
		this.canRefundPoints = canRefundPoints;
	}

	/**
	 * Whether bounty start activities can be created via the JavaScript API
	 * @return
	 */
	public Boolean getCanStartBounty() { return canStartBounty; }
	public void setCanStartBounty( Boolean canStartBounty ) {
		initializedFields.add( "canStartBounty" );
		this.canStartBounty = canStartBounty;
	}

	/**
	 * Whether bounty award activities can be created via the JavaScript API
	 * @return
	 */
	public Boolean getCanAwardBounty() { return canAwardBounty; }
	public void setCanAwardBounty( Boolean canAwardBounty ) {
		initializedFields.add( "canAwardBounty" );
		this.canAwardBounty = canAwardBounty;
	}

	/**
	 * Whether bounty cancel activities can be created via the JavaScript API
	 * @return
	 */
	public Boolean getCanCancelBounty() { return canCancelBounty; }
	public void setCanCancelBounty( Boolean canCancelBounty ) {
		initializedFields.add( "canCancelBounty" );
		this.canCancelBounty = canCancelBounty;
	}

	/**
	 * Whether gift activities can be created via the JavaScript API
	 * @return
	 */
	public Boolean getCanCreateGift() { return canCreateGift; }
	public void setCanCreateGift( Boolean canCreateGift ) {
		initializedFields.add( "canCreateGift" );
		this.canCreateGift = canCreateGift;
	}

	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
