/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.site.model.authentication;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to synchronising SAML users
 */
@ToString
@EqualsAndHashCode
public class SamlSyncUserAttributesDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private String uuid;
	private String email;
	private String firstName;
	private String lastName;


	/**
	 * The attribute field to use when loading the user unique ID.
	 * This will be used as the username on login.
	 * @return
	 */
	public String getUuid()
	{
		return uuid;
	}
	public void setUuid( String uuid )
	{
		initializedFields.add( "uuid" );
		this.uuid = uuid;
	}


	/**
	 * The attribute field to use when loading the user first name.
	 * @return
	 */
	public String getFirstName()
	{
		return firstName;
	}
	public void setFirstName( String pFirstName )
	{
		initializedFields.add( "firstName" );
		firstName = pFirstName;
	}

	/**
	 * The attribute field to use when loading the user last name.
	 * @return
	 */
	public String getLastName()
	{
		return lastName;
	}
	public void setLastName( String pLastName )
	{
		initializedFields.add( "lastName" );
		lastName = pLastName;
	}

	/**
	 * The attribute field to use when loading the user email.
	 * @return
	 */
	public String getEmail()
	{
		return email;
	}
	public void setEmail( String pEmail )
	{
		initializedFields.add( "email" );
		email = pEmail;
	}

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
