/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.site.model.authentication;

import java.util.List;

import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class specify the context with which the JWT authentication runs.
 */
@ToString
@EqualsAndHashCode
public class JwtAuthenticationContextDto implements AuthenticationContextDto
{
	private transient List<String> initializedFields = ListUtils.newArrayList( "type" );

	private String jwksUrl;
	private String uuidClaim;
	private String issuer;
	private String audience;
	private JwtAlgorithm algorithm;


	/**
	 * The type of authentication context: jwt
	 * @return
	 */
	@Override
	public AuthType getAuthType() {
		return AuthType.JWT;
	}

	/**
	 * The type of authentication context parameter settings attribute
	 * @return
	 */
	@Override
	public String getType() {
		return AuthType.JWT.value();
	}

	/**
	 * The URL used to retrieve the JSON Web Key Set used to validate the JWT token
	 * @return
	 */
	public String getJwksUrl() {
		return jwksUrl;
	}
	public void setJwksUrl( String jwksUrl ) {
		initializedFields.add( "jwksUrl" );
		this.jwksUrl = jwksUrl;
	}

	/**
	 * The claim in the JWT token which contains the Unique User ID
	 */
	public String getUuidClaim() {
		return uuidClaim;
	}
	public void setUuidClaim( String uuidClaim ) {
		initializedFields.add( "uuidClaim" );
		this.uuidClaim = uuidClaim;
	}

	/**
	 * The expected issuer of the JWT token
	 * @return
	 */
	public String getIssuer() {
		return issuer;
	}
	public void setIssuer( String issuer ) {
		initializedFields.add( "issuer" );
		this.issuer = issuer;
	}

	/**
	 * The expected audience of the JWT token
	 * @return
	 */
	public String getAudience() {
		return audience;
	}
	public void setAudience( String audience ) {
		initializedFields.add( "audience" );
		this.audience = audience;
	}

	/**
	 * The expected algorithm for the JWT token
	 *
	 * @return
	 */
	public JwtAlgorithm getAlgorithm() {
		return algorithm;
	}
	public void setAlgorithm( JwtAlgorithm algorithm ) {
		initializedFields.add( "algorithm" );
		this.algorithm = algorithm;
	}

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
