/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.site.model.authentication;

import java.util.List;

import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates the data for the DATABASE authentication method.
 */
@ToString
@EqualsAndHashCode
public class DatabaseAuthenticationContextDto implements AuthenticationContextDto
{
	/**
	 * The type of authentication context: database
	 *
	 * @return
	 */
	@Override
	public AuthType getAuthType() { return AuthType.DATABASE; }

	/**
	 * The type of authentication context parameter settings attribute
	 *
	 * @return
	 */
	@Override
	public String getType() { return AuthType.DATABASE.value();	}


	@Override
	public List<String> getInitializedFields() {
		return ListUtils.newArrayList( "type" );
	}
}
