/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.site.model.authentication;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates the data required to redirect
 * users if the log in successfully.
 */
@ToString
@EqualsAndHashCode
public class AuthenticationRedirectDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private Boolean useRefererRedirect;
	private String defaultRedirectUrl;

	/**
	 * Whether the Referer header should be used to redirect
	 * the user which is logging in
	 * @return
	 */
	public Boolean getUseRefererRedirect() {
		return useRefererRedirect;
	}
	public void setUseRefererRedirect( Boolean useRefererRedirect ) {
		initializedFields.add( "useRefererRedirect" );
		this.useRefererRedirect = useRefererRedirect;
	}

	/**
	 * This is the default redirect URL. This is used
	 * if no redirect URL is found in the query parameters
	 * and in the Referer header.
	 * @return
	 */
	public String getDefaultRedirectUrl() {
		return defaultRedirectUrl;
	}
	public void setDefaultRedirectUrl( String defaultRedirectUrl ) {
		initializedFields.add( "defaultRedirectUrl" );
		this.defaultRedirectUrl = defaultRedirectUrl;
	}

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
