/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.site.model.authentication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;

import io.mambo.sdk.service.common.data.RequestData;

import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * This class encapsulates type and details on
 * authentication method
 */
@JsonTypeInfo(
		use = JsonTypeInfo.Id.NAME,
		include = JsonTypeInfo.As.EXISTING_PROPERTY,
		property = "type")
@JsonSubTypes( {
	@Type( value = DatabaseAuthenticationContextDto.class, name = "database" ),
	@Type( value = LdapAuthenticationContextDto.class, name = "ldap" ),
	@Type( value = SamlAuthenticationContextDto.class, name = "saml" ),
	@Type( value = JwtAuthenticationContextDto.class, name = "jwt" ),
	@Type( value = NoAuthAuthenticationContextDto.class, name = "noauth" )})
public interface AuthenticationContextDto extends RequestData
{
	/**
	 * The type of AuthenticationContext.
	 *
	 * @return
	 */
	@JsonIgnore
	public AuthType getAuthType();

	/**
	 * The type of authentication context parameter settings attribute.
	 *
	 * @return
	 */
	public String getType();

}
