/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.site.model.authentication;

import io.mambo.sdk.utils.StringUtils;
/**
 * This enum lists the supported types of authentication methods
 */
public enum AuthType
{
	DATABASE( "database" ), LDAP( "ldap" ), SAML( "saml" ), JWT( "jwt" ), NOAUTH( "noauth" );
	private String type;

	private AuthType( final String pType ) {
		type = pType;
	}

	public String value() { return type; }
	public Boolean isDatabase() { return this == DATABASE; }
	public Boolean isLdap() { return this == LDAP; }
	public Boolean isSaml() { return this == SAML; }
	public Boolean isJwt() { return this == JWT; }
	public Boolean isNoAuth() {return this == NOAUTH; }

	public static AuthType fromString( final String type )
	{
		if( StringUtils.isEmpty( type ) ) {
			throw new IllegalArgumentException( "AuthType type cannot be empty" );
		}

		for( final AuthType ps : AuthType.values() ) {
			if( type.equalsIgnoreCase( ps.type ) ) {
				return ps;
			}
		}
		return null;
	}
}
