/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.reward.model.attributes;

import java.util.List;

import io.mambo.sdk.service.reward.model.AbstractReward.RewardType;
import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Defines reward attributes specific to missions.
 */
@ToString
@EqualsAndHashCode
public class MissionAttrs implements RewardAttrs
{
	private transient List<String> initializedFields = ListUtils.newArrayList("type");

	private String missionType;


	/**
	 * The type of attribute
	 * @return
	 */
	@Override
	public String getType() { return RewardType.MISSION.value(); }

	/**
	 * The type of the mission. This will be either: linear or random.
	 * See the mission page in administration panel for more information.
	 * @return
	 */
	public String getMissionType() { return missionType; }
	public void setMissionType( String missionType ) {
		initializedFields.add( "missionType" );
		this.missionType = missionType;
	}

	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
