/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.reward.model.attributes;

import java.util.List;

import io.mambo.sdk.service.reward.model.AbstractReward.RewardType;
import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Defines reward attributes specific to Levels.
 */
@ToString
@EqualsAndHashCode
public class LevelAttrs implements RewardAttrs
{
	private transient List<String> initializedFields = ListUtils.newArrayList("type");

	private Boolean reputation;


	/**
	 * The type of attribute
	 * @return
	 */
	@Override
	public String getType() { return RewardType.LEVEL.value(); }

	/**
	 * The reputation flag determines if this is a reputation level or
	 * a regular level. Reputation levels will fluctuate based on the
	 * number of points the user currently has. This means that users
	 * can lose a reputation level if they lose the points necessary
	 * to maintain that level. For example:
	 * Reputation Level 1 = 1 points
	 * Reputation Level 2 = 100 points
	 * If the user has 100 points but then loses 10 points, they will
	 * move from Reputation Level 2 to Reputation Level 1.
	 * @return
	 */
	public Boolean getReputation() { return reputation; }
	public void setReputation( Boolean reputation ) {
		initializedFields.add( "reputation" );
		this.reputation = reputation;
	}

	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
