/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.reward.model.attributes;

import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasRecurrence;
import io.mambo.sdk.service.common.model.recurrence.FixedPeriodRecurrenceDto;
import io.mambo.sdk.service.common.model.recurrence.NeverRecurrenceDto;
import io.mambo.sdk.service.common.model.recurrence.RecurrenceDto;
import io.mambo.sdk.service.common.model.recurrence.VariablePeriodRecurrenceDto;
import io.mambo.sdk.service.reward.model.AbstractReward.RewardType;
import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Defines reward attributes specific to Achievements.
 */
@ToString
@EqualsAndHashCode
public class AchievementAttrs implements RewardAttrs, HasRecurrence
{
	private transient List<String> initializedFields = ListUtils.newArrayList("type");

	private RecurrenceDto expiration;

	/**
	 * The type of attribute
	 * @return
	 */
	@Override
	public String getType() { return RewardType.ACHIEVEMENT.value(); }

	/**
	 * If the achievement is expirable then this field should contain the general
	 * expiration information. See the {@link ExpirationData} object for more information.
	 * Achievements support the following types of reset: never, fixed_period and variable_period
	 * See the {@link NeverRecurrenceDto}, {@link FixedPeriodRecurrenceDto} and
	 * {@link VariablePeriodRecurrenceDto} objects for more information.
	 */
	@Override
	public RecurrenceDto getExpiration() { return expiration; }
	@Override
	public void setExpiration( RecurrenceDto expiration ) {
		initializedFields.add( "expiration" );
		this.expiration = expiration;
	}

	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
