/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.reward.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.behaviour.model.BehaviourDto;
import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.service.point.model.PointDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a reward's unlock conditions
 */
@ToString
@EqualsAndHashCode
public class UnlockConditionDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private String type;
	private String targetId;
	private Long threshold;

	private PointDto point;
	private BehaviourDto behaviour;
	private RewardDto reward;


	/**
	 * The type of target used to unlock the reward.
	 * Valid types include: point, behaviour and reward
	 * @return
	 */
	public String getType() { return type; }
	public void setType( String type ) {
		initializedFields.add( "type" );
		this.type = type;
	}

	/**
	 * The ID of the target that needs to be achieved for unlock
	 * @return
	 */
	public String getTargetId() { return targetId; }
	public void setTargetId( String targetId ) {
		initializedFields.add( "targetId" );
		this.targetId = targetId;
	}

	/**
	 * The minimum number of times the target must be met to unlock the reward
	 * @return
	 */
	public Long getThreshold() { return threshold; }
	public void setThreshold( Long threshold ) {
		initializedFields.add( "threshold" );
		this.threshold = threshold;
	}

	/**
	 * The model representing the underlying point.
	 * @return
	 */
	public PointDto getPoint() { return point; }
	public void setPoint( PointDto point ) {
		this.point = point;
	}

	/**
	 * The model representing the underlying behaviour.
	 * @return
	 */
	public BehaviourDto getBehaviour() { return behaviour; }
	public void setBehaviour( BehaviourDto behaviour ) {
		this.behaviour = behaviour;
	}

	/**
	 * The model representing the underlying reward.
	 * @return
	 */
	public RewardDto getReward() { return reward; }
	public void setReward( RewardDto reward ) {
		this.reward = reward;
	}


	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}