/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.reward.model;

import java.util.List;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a user's progress in
 * relation to a reward.
 */
@ToString
@EqualsAndHashCode
public class ProgressDto
{
	private Long required = 0L;
	private Long completed = 0L;
	private List<ConditionProgressDto> conditionProgress;


	/**
	 * The number of items associated to this reward that the user must unlock.
	 * @return
	 */
	public Long getRequired() { return required; }
	public void setRequired( Long required ) { this.required = required; }


	/**
	 * How many of the items in the reward the user has completed
	 * @return
	 */
	public Long getCompleted() { return completed; }
	public void setCompleted( Long completed ) { this.completed = completed; }


	/**
	 * The progress of the individual condition that make up the reward
	 * @return
	 */
	public List<ConditionProgressDto> getConditionProgress() { return conditionProgress; }
	public void setConditionProgress( List<ConditionProgressDto> conditionProgress ) { this.conditionProgress = conditionProgress; }
}
