/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.reward.model;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a user's progress in
 * relation to a reward's condition
 */
@ToString
@EqualsAndHashCode
public class ConditionProgressDto
{
	private String targetId;
	private Long required = 0L;
	private Long completed = 0L;


	/**
	 * The ID of the condition's target
	 * @return
	 */
	public String getTargetId() { return targetId; }
	public void setTargetId( String targetId ) { this.targetId = targetId; }


	/**
	 * The number of times the condition needs to be completed in order to
	 * be considered complete.
	 * @return
	 */
	public Long getRequired() { return required; }
	public void setRequired( Long required ) { this.required = required; }


	/**
	 * The number of times the condition has been completed.
	 * @return
	 */
	public Long getCompleted() { return completed; }
	public void setCompleted( Long completed ) { this.completed = completed; }
}
