/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.point.model;

import io.mambo.sdk.service.common.model.summary.SummaryDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * The transaction parent contains information about the
 * mechanic which awarded the points of the transaction.
 */
@ToString
@EqualsAndHashCode
public class TransactionParentDto
{
	private String parentType;
	private String parentId;
	private SummaryDto parentSummary;


	/**
	 * The type of mechanic that changed the points.
	 * Available types: activity, behaviour, reward, kpi, coupon
	 * @return
	 */
	public String getType() { return parentType; }
	public void setType( String parentType ) { this.parentType = parentType; }


	/**
	 * The ID of the mechanic that changed the points
	 * @return
	 */
	public String getId() { return parentId; }
	public void setId( String parentId ) { this.parentId = parentId; }


	/**
	 * The summary of the mechanic that changed the points
	 * @return
	 */
	public SummaryDto getSummary() { return parentSummary; }
	public void setSummary( SummaryDto parentSummary ) { this.parentSummary = parentSummary; }
}
