/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.point.model;

import io.mambo.sdk.service.common.model.translation.AbstractTranslationDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to the translations of a point
 */
@ToString( callSuper = true )
@EqualsAndHashCode( callSuper = true )
public class PointTranslationDto extends AbstractTranslationDto
{
	private String name;
	private String description;
	private String prefix;
	private String postfix;
	private String plural;
	private String singular;
	private String abbrPlural;
	private String abbrSingular;


	/**
	 * The name of the tag translated.
	 * See the tag page in administration panel for more information.
	 */
	public String getName() { return name; }
	public void setName( String name ) {
		initializedFields.add( "name" );
		this.name = name;
	}

	/**
	 * The description associated with the point.
	 * See the points page in administration panel for more information.
	 * @return
	 */
	public String getDescription() { return description; }
	public void setDescription( String description ) {
		initializedFields.add( "description" );
		this.description = description;
	}

	/**
	 * The units of measure used as a prefix to the point, for example: $
	 * See the points page in administration panel for more information.
	 * @return
	 */
	public String getPrefix() { return prefix; }
	public void setPrefix( String prefix ) {
		initializedFields.add( "prefix" );
		this.prefix = prefix;
	}

	/**
	 * The units of measure used as a postfix to the point, for example: %
	 * See the points page in administration panel for more information.
	 * @return
	 */
	public String getPostfix() { return postfix; }
	public void setPostfix( String postfix ) {
		initializedFields.add( "postfix" );
		this.postfix = postfix;
	}

	/**
	 * The units of measure used to describe more than one point, for example: 10 points
	 * See the points page in administration panel for more information.
	 * @return
	 */
	public String getPlural() { return plural; }
	public void setPlural( String plural ) {
		initializedFields.add( "plural" );
		this.plural = plural;
	}

	/**
	 * The units of measure used to describe one point, for example: 1 point
	 * See the points page in administration panel for more information.
	 * @return
	 */
	public String getSingular() { return singular; }
	public void setSingular( String singular ) {
		initializedFields.add( "singular" );
		this.singular = singular;
	}

	/**
	 * The units of measure used to describe the abbreviation for more
	 * than one point, for example: 10 pts
	 * See the points page in administration panel for more information.
	 * @return
	 */
	public String getAbbrPlural() { return abbrPlural; }
	public void setAbbrPlural( String abbrPlural ) {
		initializedFields.add( "abbrPlural" );
		this.abbrPlural = abbrPlural;
	}

	/**
	 * The units of measure used to describe the abbreviation one point, for example: 1 pt
	 * See the points page in administration panel for more information.
	 * @return
	 */
	public String getAbbrSingular() { return abbrSingular; }
	public void setAbbrSingular( String abbrSingular ) {
		initializedFields.add( "abbrSingular" );
		this.abbrSingular = abbrSingular;
	}
}
