/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.point.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a point's decimals
 */
@ToString
@EqualsAndHashCode
public class DecimalsDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private Integer precision;
	private String rounding;


	/**
	 * The precision defines the number of decimal places that should be
	 * used for this point. The default is 0 decimal places and the maximum
	 * is 10 decimal places.
	 * @return
	 */
	public Integer getPrecision() { return precision; }
	public void setPrecision( Integer precision ) {
		initializedFields.add( "precision" );
		this.precision = precision;
	}

	/**
	 * The rounding defines how the decimal places should be rounded if
	 * the API receives a point value with more decimal places than
	 * the one specified when configuring the point. Possible rounding values
	 * include: up, down, ceiling, floor, half_up, half_down, half_even
	 * @return
	 */
	public String getRounding() { return rounding; }
	public void setRounding( String rounding ) {
		initializedFields.add( "rounding" );
		this.rounding = rounding;
	}

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
