/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.notification.model;

import io.mambo.sdk.service.activity.model.ActivityDto;
import io.mambo.sdk.service.common.model.SourceActivityDto;
import io.mambo.sdk.service.common.model.awarded.AwardedDto;
import io.mambo.sdk.service.common.model.interfaces.AggregateDto;
import io.mambo.sdk.service.common.model.interfaces.HasId;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a notification.
 */
@ToString
@EqualsAndHashCode
public class NotificationDto implements AggregateDto, HasId
{
	private String id;
	private String userId;
	private String createdOn;
	private Boolean isRead;
	private AwardedDto awarded;
	private ActivityDto activity;
	private SourceActivityDto source;


	/**
	 * This ID uniquely identifies this object
	 */
	@Override
	public String getId() { return id; }
	public void setId( String id ) { this.id = id; }


	/**
	 * The ID of the user who is being notified.
	 * @return
	 */
	public String getUserId() { return userId; }
	public void setUserId( String userId ) { this.userId = userId; }

	/**
	 * The model representing the activity that triggered this notification.
	 * This field will be populated if the API call has the withActivities
	 * flag set to true.
	 * @return
	 */
	public ActivityDto getActivity() { return activity; }
	public void setActivity( ActivityDto activity ) { this.activity = activity; }

	/**
	 * The source activity that generated this notification
	 * @return
	 */
	public SourceActivityDto getSource() { return source; }
	public void setSource( SourceActivityDto source ) { this.source = source; }


	/**
	 * The time and date on which the notification was created.
	 * This will be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ
	 * @return
	 */
	public String getCreatedOn() { return  createdOn; }
	public void setCreatedOn( String createdOn ) { this.createdOn = createdOn; }


	/**
	 * Whether this notification has been read by the user
	 * and marked as cleared.
	 * @return
	 */
	public Boolean isRead() { return  isRead; }
	public void setIsRead( Boolean isRead ) { this.isRead = isRead; }

	/**
	 * The awarded object which triggered the notification
	 * @return
	 */
	public AwardedDto getAwarded() { return awarded; }
	public void setAwarded( AwardedDto awarded ) { this.awarded = awarded; }
}
