/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.leaderboard.param;

import static io.mambo.sdk.utils.Preconditions.checkContainsKey;
import static io.mambo.sdk.utils.Preconditions.checkNotNull;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;

public class LeaderboardUpdateParams implements ServiceParams
{
	private Multimap<String, String> params = new Multimap<>();


	private LeaderboardUpdateParams( Builder builder ) {
		this.params = builder.params();
	}


	public static Builder builder()
	{
		return new Builder();
	}


	@Override
	public Multimap<String, String> asMap()
	{
		return params;
	}


	public static class Builder extends AbstractServiceParamsBuilder<Builder>
	{
		private static final String LEADERBOARD_ID_MUST_NOT_BE_NULL = "leaderboardId must not be null";


		/**
		 * The ID of the leaderboard to update
		 */
		public Builder leaderboardId( String leaderboardId )
		{
			checkNotNull( leaderboardId, LEADERBOARD_ID_MUST_NOT_BE_NULL );
			params.put( "leaderboardId", leaderboardId );
			return this;
		}


		public LeaderboardUpdateParams build()
		{
			checkContainsKey( params, "leaderboardId", LEADERBOARD_ID_MUST_NOT_BE_NULL );
			return new LeaderboardUpdateParams( this );
		}


		private Multimap<String, String> params()
		{
			return params;
		}
	}
}
