/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.leaderboard.model.attributes;

import java.util.List;

import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Defines leaderboard attributes specific to point leaderboards.
 */
@ToString
@EqualsAndHashCode
public class LeaderboardPointAttrs implements LeaderboardAttrs
{
	private transient List<String> initializedFields = ListUtils.newArrayList( "type" );


	/**
	 * The type of attribute
	 * @return
	 */
	@Override
	public String getType() { return "point"; }

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
