/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.leaderboard.model.attributes;

import java.util.List;

import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Defines leaderboard attributes specific to behaviour leaderboards.
 */
@ToString
@EqualsAndHashCode
public class LeaderboardBehaviourAttrs implements LeaderboardAttrs
{
	private transient List<String> initializedFields = ListUtils.newArrayList( "type" );

	private String behaviourName;
	private String behaviourId;
	private Boolean countFlex;


	/**
	 * The type of attribute
	 * @return
	 */
	@Override
	public String getType() { return "behaviour"; }

	/**
	 * The Name of the behaviour associated to this leaderboard.
	 * See the leaderboard page in administration panel for more information.
	 * @return
	 */
	public String getBehaviourName() { return behaviourName; }
	public void setBehaviourName( String behaviourName ) {
		initializedFields.add( "behaviourName" );
		this.behaviourName = behaviourName;
	}

	/**
	 * The ID of the behaviour associated to this leaderboard.
	 * See the leaderboard page in administration panel for more information.
	 * @return
	 */
	public String getBehaviourId() { return behaviourId; }
	public void setBehaviourId( String behaviourId ) {
		initializedFields.add( "behaviourId" );
		this.behaviourId = behaviourId;
	}

	/**
	 * For leaderboards based on simple behaviours, this flag indicates whether the flexible
	 * behaviours associated to the simple one should also be counted in the points for this
	 * leaderboard.
	 * See the leaderboard page in administration panel for more information.
	 * @return
	 */
	public Boolean getCountFlex() { return countFlex; }
	public void setCountFlex( Boolean countFlex ) {
		initializedFields.add( "countFlex" );
		this.countFlex = countFlex;
	}

	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
