/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.leaderboard.model;

import io.mambo.sdk.service.common.model.translation.AbstractTranslationDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to the translations of a leaderboard
 */
@ToString( callSuper = true )
@EqualsAndHashCode( callSuper = true )
public class LeaderboardTranslationDto extends AbstractTranslationDto
{
	private String name;


	/**
	 * The name of the leaderboard. See the leaderboard page in
	 * administration panel for more information.
	 * @return
	 */
	public String getName() { return name; }
	public void setName( String name )
	{
		initializedFields.add( "name" );
		this.name = name;
	}
}
