/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.language.model;

import io.mambo.sdk.service.common.model.interfaces.AggregateDto;
import io.mambo.sdk.service.common.model.interfaces.HasId;
import io.mambo.sdk.service.language.data.LanguageRequestData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a language.
 */
@ToString( callSuper = true )
@EqualsAndHashCode( callSuper = true )
public class LanguageDto extends LanguageRequestData implements AggregateDto, HasId
{
	private String id;
	private Boolean isSystemLanguage;


	/**
	 * This ID uniquely identifies this object
	 */
	@Override
	public String getId() { return id; }
	public void setId( String id ) { this.id = id; }


	/**
	 * Indicates whether the language is a system language or a custom language.
	 * See the languages page in administration panel for more information.
	 * @return
	 */
	public Boolean getSystemLanguage() { return isSystemLanguage; }
	public void setSystemLanguage( Boolean isSystemLanguage ) { this.isSystemLanguage = isSystemLanguage; }
}
