/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.language.data;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.data.RequestData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This object captures the data required by the Language API in
 * order to create and update languages.
 */
@ToString
@EqualsAndHashCode
public class LanguageRequestData implements RequestData
{
	protected transient List<String> initializedFields = new ArrayList<>();

	private String name;
	private String languageCode;
	private Boolean isDefault;

	/**
	 * The name of the language.
	 * See the language page in administration panel for more information.
	 */
	public String getName() { return name; }
	public void setName( String name ) {
		initializedFields.add( "name" );
		this.name = name;
	}


	/**
	 * This is the language code which is used in the "Accept-Language" header
	 * when making requests to the server. This value must only contain letters,
	 * numbers and underscores. The language code must be unique in order to
	 * identify the specific Language.
	 * See the language page in administration panel for more information.
	 * @return
	 */
	public String getLanguageCode() { return languageCode; }
	public void setLanguageCode( String languageCode ) {
		initializedFields.add( "languageCode" );
		this.languageCode = languageCode;
	}


	/**
	 * Indicates whether this is the default language to be used for the site.
	 * The default language is the one used when no "Accept-Language" header
	 * is provided. There must always be at least one default language.
	 * See the language page in administration panel for more information.
	 * @return
	 */
	public Boolean getIsDefault() { return isDefault; }
	public void setIsDefault( Boolean isDefault ) {
		initializedFields.add( "isDefault" );
		this.isDefault = isDefault;
	}


	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}