/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.kpi.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.behaviour.model.BehaviourDto;
import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.service.point.model.PointDto;
import io.mambo.sdk.service.reward.model.RewardDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a KPIs tracked game mechanic
 */
@ToString
@EqualsAndHashCode
public class TrackedDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private String type;
	private String id;
	private Boolean ignoreExpiredPoints;
	private PointDto point;
	private BehaviourDto behaviour;
	private RewardDto reward;


	/**
	 * The type of mechanic that should be tracked by the KPI.
	 * Valid types include: point, behaviour and reward
	 * @return
	 */
	public String getType() { return type; }
	public void setType( String type ) {
		initializedFields.add( "type" );
		this.type = type;
	}


	/**
	 * Get the ID of the mechanic being tracked
	 * @return
	 */
	public String getId() { return id; }
	public void setId( String id ) {
		initializedFields.add( "id" );
		this.id = id;
	}


	/**
	 * If we are tracking a point, this determines whether expired points
	 * should be ignored or whether they should decrease a user's actuals.
	 * @return
	 */
	public Boolean getIgnoreExpiredPoints() { return ignoreExpiredPoints; }
	public void setIgnoreExpiredPoints( Boolean ignoreExpiredPoints ) {
		initializedFields.add( "ignoreExpiredPoints" );
		this.ignoreExpiredPoints = ignoreExpiredPoints;
	}

	/**
	 * If the tracked type is point, then this will contain
	 * the point that is being tracked
	 * @return
	 */
	public PointDto getPoint() { return point; }

	/**
	 * If the tracked type is behaviour, then this will contain
	 * the behaviour that is being tracked
	 * @return
	 */
	public BehaviourDto getBehaviour() { return behaviour; }

	/**
	 * If the tracked type is reward, then this will contain
	 * the reward that is being tracked
	 * @return
	 */
	public RewardDto getReward() { return reward; }

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
