/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.kpi.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to
 * ranges of a KPIs RAG progress bar
 */
@ToString
@EqualsAndHashCode
public class RedAmberGreenRangeDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private String colour;
	private String state;
	private Long upto;


	/**
	 * This represents the state label to be used with this RAG range.
	 * For example: Ok, Warning, Critical
	 * @return
	 */
	public String getState() { return state; }
	public void setState( String state ) {
		initializedFields.add( "state" );
		this.state = state;
	}


	/**
	 * This represents which colour should be used. This should be in either Hex format
	 * (e.g. #FFFFFF), RGB (e.g. rgb(0,0,0)) or RGBA (e.g. rgba(0,0,0,0.5)
	 * Note: this property will be added directly to the CSS background
	 * color property, so it must be a valid value.
	 * @return
	 */
	public String getColour() { return colour; }
	public void setColour( String colour ) {
		initializedFields.add( "colour" );
		this.colour = colour;
	}


	/**
	 * This represents the upper value up until which this colour
	 * should be applied. Note that this will rely on other
	 * RedAmberGreenData to determine from where this colour
	 * should start.
	 * @return
	 */
	public Long getUpTo() { return upto; }
	public void setUpTo( Long upto ) {
		initializedFields.add( "upto" );
		this.upto = upto;
	}

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
