/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.kpi.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a KPI RAG status
 */
@ToString
@EqualsAndHashCode
public class RedAmberGreenDto implements HasInitializedData
{
	private transient List<String> initializedFields = new ArrayList<>();

	private String unitsOfMeasure;
	private List<RedAmberGreenRangeDto> ranges;
	private Long minPercent;
	private Long maxPercent;


    /**
     * This determines which units of measure to use.
     * Possible values: percentage, point, none
     * @return
     */
    public String getUnitsOfMeasure() { return unitsOfMeasure; }
	public void setUnitsOfMeasure( String unitsOfMeasure ) {
		initializedFields.add( "unitsOfMeasure" );
		this.unitsOfMeasure = unitsOfMeasure;
	}

	/**
	 * This represents the minimum percentage value to use in the RAG ranges.
	 * For example: 0%
	 * @return
	 */
	public Long getMinPercent() { return minPercent; }
	public void setMinPercent( Long minPercent ) {
		initializedFields.add( "minPercent" );
		this.minPercent = minPercent;
	}


	/**
	 * This represents the maximum percentage value to use in the RAG ranges.
	 * For example: 100%
	 * @return
	 */
	public Long getMaxPercent() { return maxPercent; }
	public void setMaxPercent( Long maxPercent ) {
		initializedFields.add( "maxPercent" );
		this.maxPercent = maxPercent;
	}


	/**
	 * Defines the different ranges to be used when generating the KPI's RAG progress bar
	 * @return
	 */
	public List<RedAmberGreenRangeDto> getRanges() { return ranges; }
	public void setRanges( List<RedAmberGreenRangeDto> ranges ) {
		initializedFields.add( "ranges" );
		this.ranges = ranges;
	}

	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
