/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.kpi.model;

import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.AggregateDto;
import io.mambo.sdk.service.common.model.interfaces.HasId;
import io.mambo.sdk.service.common.model.tag.HasTags;
import io.mambo.sdk.service.tag.model.TagDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a KPI target.
 */
@ToString( callSuper = true )
@EqualsAndHashCode( callSuper = true )
public class KpiTargetDto extends AbstractKpiTarget implements AggregateDto, HasTags, HasId
{
	private String id;
	private String siteId;
	private String kpiId;
	private String name;
	private List<TagDto> tags;
	private List<String> tagIds;


	/**
	 * This ID uniquely identifies this object
	 */
	@Override
	public String getId() { return id; }
	public void setId( String id ) { this.id = id; }

	/**
	 * The ID of the site to which the KPI target belongs.
	 */
	public String getSiteId() { return siteId; }
	public void setSiteId( String siteId ) { this.siteId = siteId; }

	/**
	 * The Id of the KPI to which the target belongs
	 */
	public String getKpiId() { return kpiId; }
	public void setKpiId( String kpiId ) { this.kpiId = kpiId; }

	/**
	 * The name of the KPI target represented by its period (start and end dates).
	 */
	public String getName() { return name; }
	public void setName( String name ) { this.name = name; }


	/**
	 * This should contain the list of the IDs of the tags which
	 * must be added to the object.
	 * @return
	 */
	@Override
	public List<String> getTagIds() { return tagIds; }
	@Override
	public void setTagIds( List<String> tagIds ) {
		this.tagIds = tagIds;
	}


	/**
	 * This contains the list of {@link TagDto} associated to this object.
	 * @return
	 */
	@Override
	public List<TagDto> getTags() { return tags; }
	@Override
	public void setTags( List<TagDto> tags ) {
		this.tags = tags;
	}

}
