/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.kpi.model;

import java.util.List;
import java.util.Map;

import io.mambo.sdk.service.common.model.interfaces.AggregateDto;
import io.mambo.sdk.service.common.model.interfaces.HasId;
import io.mambo.sdk.service.common.model.tag.HasTags;
import io.mambo.sdk.service.tag.model.TagDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a KPI.
 */
@ToString
@EqualsAndHashCode
public class KpiStateDto implements AggregateDto, HasTags, HasId
{
	private String id;
	private String siteId;
	private String kpiId;
	private String userId;
	private Integer year;
	private Map<Integer,KpiTrackerDto> daily;
	private Map<Integer,KpiTrackerDto> weekly;
	private Map<Integer,KpiTrackerDto> monthly;
	private Map<Integer,KpiTrackerDto> quarterly;
	private KpiTrackerDto yearly;
	private KpiDto kpi;
	private List<TagDto> tags;
	private List<String> tagIds;


	/**
	 * This ID uniquely identifies this object
	 */
	@Override
	public String getId() { return id; }
	public void setId( String id ) { this.id = id; }

	/**
	 * The ID of the site to which the KPI belongs.
	 */
	public String getSiteId() { return siteId; }
	public void setSiteId( String siteId ) { this.siteId = siteId; }

	/**
	 * The Id of the KPI Aggregate
	 */
	public String getKpiId() { return kpiId; }
	public void setKpiId( String kpiId ) { this.kpiId = kpiId; }

	/**
	 * The Id of the User Aggregate
	 */
	public String getUserId() { return userId; }
	public void setUserId( String userId ) { this.userId = userId; }

	/**
	 * Gets the year being tracked by the KPIStateDto
	 */
	public Integer getYear() { return year; }
	public void setYear( Integer year ) { this.year = year; }

	/**
	 * Get the trackers used to track daily KPI progress.
	 * This will contain 365-366 different trackers
	 */
	public Map<Integer,KpiTrackerDto> getDaily() { return daily; }
	public void setDaily( Map<Integer,KpiTrackerDto> daily ) { this.daily = daily; }

	/**
	 * Get the trackers used to track weekly KPI progress.
	 * This will contain 52-53 different trackers
	 */
	public Map<Integer,KpiTrackerDto> getWeekly() { return weekly; }
	public void setWeekly( Map<Integer,KpiTrackerDto> weekly ) { this.weekly = weekly; }

	/**
	 * Get the trackers used to track monthly KPI progress.
	 * This will contain 12 different trackers
	 */
	public Map<Integer,KpiTrackerDto> getMonthly() { return monthly; }
	public void setMonthly( Map<Integer,KpiTrackerDto> monthly ) { this.monthly = monthly; }

	/**
	 * Get the trackers used to track quarterly KPI progress.
	 * This will contain 4 different trackers
	 */
	public Map<Integer,KpiTrackerDto> getQuarterly() { return quarterly; }
	public void setQuarterly( Map<Integer,KpiTrackerDto> quarterly ) { this.quarterly = quarterly; }

	/**
	 * Get the trackers used to track yearly KPI progress.
	 */
	public KpiTrackerDto getYearly() { return yearly; }
	public void setYearly( KpiTrackerDto yearly ) { this.yearly = yearly; }

	/**
	 * The KPI associated to this KPI User
	 */
	public KpiDto getKpi() { return kpi; }
	public void setKpi( KpiDto kpi ) { this.kpi = kpi; }

	/**
	 * This should contain the list of the IDs of the tags which
	 * must be added to the object.
	 * @return
	 */
	@Override
	public List<String> getTagIds() { return tagIds; }
	@Override
	public void setTagIds( List<String> tagIds ) {
		this.tagIds = tagIds;
	}


	/**
	 * This contains the list of {@link TagDto} associated to this object.
	 * @return
	 */
	@Override
	public List<TagDto> getTags() { return tags; }
	@Override
	public void setTags( List<TagDto> tags ) {
		this.tags = tags;
	}
}
