/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.kpi.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.service.kpi.data.KpiTargetRequestData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Target data shared by {@link KpiTargetDto} and {@link KpiTargetRequestData}
 */
@ToString
@EqualsAndHashCode
public abstract class AbstractKpiTarget implements HasInitializedData
{
	protected transient List<String> initializedFields = new ArrayList<>();

	private String startDate;
	private String endDate;
	private Long daily;
	private Long weekly;
	private Long monthly;
	private Long quarterly;
	private Long yearly;
	private List<String> userUUIDs;
	private List<String> userIds;


	/**
	 * Defines the KPIs daily target
	 * @return
	 */
	public Long getDaily() { return daily; }
	public void setDaily( Long daily ) { initializedFields.add( "daily" ); this.daily = daily; }


	/**
	 * Defines the KPIs weekly target
	 * @return
	 */
	public Long getWeekly() { return weekly; }
	public void setWeekly( Long weekly ) { initializedFields.add( "weekly" ); this.weekly = weekly; }


	/**
	 * Defines the KPIs monthly target
	 * @return
	 */
	public Long getMonthly() { return monthly; }
	public void setMonthly( Long monthly ) { initializedFields.add( "monthly" ); this.monthly = monthly; }


	/**
	 * Defines the KPIs quarterly target
	 * @return
	 */
	public Long getQuarterly() { return quarterly; }
	public void setQuarterly( Long quarterly ) { initializedFields.add( "quarterly" ); this.quarterly = quarterly; }


	/**
	 * Defines the KPIs yearly target
	 * @return
	 */
	public Long getYearly() { return yearly; }
	public void setYearly( Long yearly ) { initializedFields.add( "yearly" ); this.yearly = yearly; }


	/**
	 * This represents the date from which these targets will be applied.
	 * This must be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ
	 * @return
	 */
	public String getStartDate() { return startDate; }
	public void setStartDate( String startDate ) { initializedFields.add( "startDate" ); this.startDate = startDate; }


	/**
	 * This represents the date until which these targets will be applied.
	 * This must be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ
	 * @return
	 */
	public String getEndDate() { return endDate; }
	public void setEndDate( String endDate ) { initializedFields.add( "endDate" ); this.endDate = endDate; }


	/**
	 * Defines the users who have personal targets
	 * @return
	 */
	public List<String> getUserUUIDs() { return userUUIDs; }
	public void setUserUUIDs( List<String> userUUIDs ) { initializedFields.add( "userUUIDs" ); this.userUUIDs = userUUIDs; }


	/**
	 * Defines the users who have personal targets
	 * @return
	 */
	public List<String> getUserIds() { return userIds; }
	public void setUserIds( List<String> userIds ) { initializedFields.add( "userIds" ); this.userIds = userIds; }


	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}
