/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.datastore.model;

import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.AggregateDto;
import io.mambo.sdk.service.common.model.interfaces.HasId;
import io.mambo.sdk.service.user.model.UserDto;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a data store.
 */
@ToString( callSuper = true )
@EqualsAndHashCode( callSuper = true )
public class DataStoreDto extends AbstractDataStore implements AggregateDto, HasId
{
	private String id;
	private Boolean isSystemDataStore;
	private UserDto ownedByUser;
	private List<UserDto> users;


	/**
	 * @see AggregateDto#getId()
	 */
	@Override
	public String getId() { return id; }
	public void setId( String id ) { this.id = id; }

	/**
	 * Indicates whether the DataStore is a system DataStore or a custom DataStore.
	 */
	public Boolean getIsSystemDataStore() { return isSystemDataStore; }
	public void setIsSystemDataStore( Boolean isSystemDataStore ) { this.isSystemDataStore = isSystemDataStore; }

	/**
	 * This contains the {@link UserDto} of the owner of this data store
	 * @return
	 */
	public UserDto getOwnedByUser() { return ownedByUser; }
	public void setOwnedByUser( UserDto ownedByUser ) {
		this.ownedByUser = ownedByUser;
	}

	/**
	 * This contains the list of {@link UserDto} with whom this data store is associated
	 * @return
	 */
	public List<UserDto> getUsers() { return users; }
	public void setUsers( List<UserDto> users ) {
		this.users = users;
	}
}
