/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.datastore.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.service.datastore.data.DataStoreRequestData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Coupon data shared by {@link DataStoreDto} and {@link DataStoreRequestData}
 */
@ToString
@EqualsAndHashCode
public class AbstractDataStore implements HasInitializedData
{
	protected transient List<String> initializedFields = new ArrayList<>();

	private String name;
	private String type;
	private String data;
	private String ownedBy;
	private List<String> userIds;
	private String timestamp;


	/**
	 * The name of the data store.
	 * @return
	 */
	public String getName() { return name; }
	public void setName( String name ) {
		initializedFields.add( "name" );
		this.name = name;
	}


	/**
	 * The type of the data store.
	 * @return
	 */
	public String getType() { return type; }
	public void setType( String type ) {
		initializedFields.add( "type" );
		this.type = type;
	}


	/**
	 * The data of the data store.
	 * @return
	 */
	public String getData() { return data; }
	public void setData( String data ) {
		initializedFields.add( "data" );
		this.data = data;
	}

	/**
	 * The AggregateId of the user who owns this data store.
	 * @return
	 */
	public String getOwnedBy() { return ownedBy; }
	public void setOwnedBy( String ownedBy ) {
		initializedFields.add( "ownedBy" );
		this.ownedBy = ownedBy;
	}

	/**
	 * Any user IDs associated to this data store.
	 * @return
	 */
	public List<String> getUserIds() { return userIds; }
	public void setUserIds( List<String> userIds ) {
		initializedFields.add( "userIds" );
		this.userIds = userIds;
	}


	/**
	 * Any time stamp associated to the data store.
	 * Allows you to filter the data stores by date.
	 * This must be a UTC timestamp in ISO 8601 format with
	 * millisecond precision: YYYY-MM-DDTHH:MM:SS.MMMZ
	 * @return
	 */
	public String getTimestamp() { return timestamp; }
	public void setTimestamp( String timestamp ) {
		initializedFields.add( "timestamp" );
		this.timestamp = timestamp;
	}

	@Override
	public List<String> getInitializedFields()
	{
		return initializedFields;
	}
}
