/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.datastore.data;

import java.util.List;

import io.mambo.sdk.service.common.data.RequestData;
import io.mambo.sdk.service.datastore.model.AbstractDataStore;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This object captures the data required by the DataStore Field API in
 * order to create and update data store fields.
 */
@ToString( callSuper = true )
@EqualsAndHashCode( callSuper = true )
public class DataStoreRequestData extends AbstractDataStore implements RequestData
{
	private String ownedByUuid;
	private List<String> userUUIDs;


	/**
	 * The UUID of the user who owns this data store.
	 * @return
	 */
	public String getOwnedByUuid() { return ownedByUuid; }
	public void setOwnedByUuid( String ownedByUuid ) {
		initializedFields.add( "ownedByUuid" );
		this.ownedByUuid = ownedByUuid;
	}

	/**
	 * Any user IDs associated to this data store by UUID
	 * @return
	 */
	public List<String> getUserUUIDs() { return userUUIDs; }
	public void setUserUUIDs( List<String> userUUIDs ) {
		initializedFields.add( "userUUIDs" );
		this.userUUIDs = userUUIDs;
	}


	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}