/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.customfield.model;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.customfield.data.CustomFieldRequestData;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Coupon data shared by {@link CustomFieldDto} and {@link CustomFieldRequestData}
 */
@ToString
@EqualsAndHashCode
public class AbstractCustomField
{
	protected transient List<String> initializedFields = new ArrayList<>();

	private String targetType;
	private String fieldName;
	private String fieldType;


	/**
	 * The target type of the custom field. Valid types include:
	 * user, behaviour, reward, point and kpi.
	 * @return
	 */
	public String getTargetType() { return targetType; }
	public void setTargetType( String targetType ) {
		initializedFields.add( "targetType" );
		this.targetType = targetType;
	}


	/**
	 * The name of the custom field.
	 * @return
	 */
	public String getFieldName() { return fieldName; }
	public void setFieldName( String fieldName ) {
		initializedFields.add( "fieldName" );
		this.fieldName = fieldName;
	}


	/**
	 * The type of the custom field. Valid types include: string, int and image.
	 * @return
	 */
	public String getFieldType() { return fieldType; }
	public void setFieldType( String fieldType ) {
		initializedFields.add( "fieldType" );
		this.fieldType = fieldType;
	}
}
