/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.service.coupon.model.code;

import java.util.List;

import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.utils.ListUtils;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This class encapsulates data related to a single coupon code
 */
@ToString
@EqualsAndHashCode
public class SingleCouponCodeDto implements HasInitializedData, CouponCodeDto
{
	private transient List<String> initializedFields = ListUtils.newArrayList("type");

	private String code;


	/**
	 * The type of couponCode: single
	 * @return
	 */
	@Override
	public String getType() { return "single"; }


	/**
	 * The coupon code to be used.
	 * @return
	 */
	public String getCode() { return code; }
	public void setCode( String code ) {
		initializedFields.add( "code" );
		this.code = code;
	}


	/**
	 * The list of initialised fields to send to the server
	 */
	@Override
	public List<String> getInitializedFields() {
		return initializedFields;
	}
}


